::/****************************************************************************************/
::/* Das DOS Batch-Script pingLogger.bat                                                  */
::/****************************************************************************************/
::/*                                                                                      */
::/* Pinglogger pingt die gewnschte IP oder Domain an, schreibt den Pong in ein Tempfile */
::/* liest dieses aus und schreibt die Werte in ein strichpunktgetrenntes Protokollfile   */
::/* Diese Datei kann mit z.B. OpenOfficeOrg Calc oder Excell direkt geffnet             */
::/* Damit die Wartefunktion unter Windows richtig funktioniert bentigt der PingLogger   */
::/* unbedingt die "sleep.exe" aus z.B. dem "Windows Server 2003 Resource Kit Tools"      */
::/* erhltlich auch hier unter http://www.universallink.ch/downloads/sleep.zip oder      */
::/* bei Microsoft.                                                                       */
::/* Weitere Infos zur sleep.ex am einfachsten erhltlich bei Google unter                */
::/* http://www.google.ch/search?hl=de&q=%2Bsleep.exe+%2Bmicrosoft+%2Bdos                 */
::/*                                                                                      */
::/* nderungen und vorallem verbesserungen am PingLogger bitte mir mitteilen,            */
::/* damit ich diese auch ins Netz stellen kann!!                                         */
::/*                                                                                      */
::/* Die Kontaktdaten findest Du unter http://ping-logger.ch                              */
::/*                                                                                      */
::/* Viel Spass beim loggen ;-)                                                           */
::/*                                                                                      */
::/* Copyright (c) <2017> <Florian Jaton>                                                 */
::/*                                                                                      */
::/* Hiermit wird unentgeltlich jeder Person, die eine Kopie der Software und der         */
::/* zugehrigen Dokumentationen (die "Software") erhlt, die Erlaubnis erteilt, sie      */
::/* zu verwenden, uneingeschrnkt zu nutzen, inklusive und ohne Ausnahme mit dem Recht,  */
::/* sie zu kopieren, zu verndern, zusammenzufgen, zu verffentlichen, zu verbreiten,   */
::/* zu unterlizenzieren und/oder zu verkaufen, und Personen, denen diese Software        */
::/* berlassen wird, diese Rechte zu verschaffen, unter den folgenden Bedingungen:       */
::/*                                                                                      */
::/* Der obige Urheberrechtsvermerk und dieser Erlaubnisvermerk sind in allen Kopien      */
::/* oder Teilkopien der Software beizulegen.                                             */
::/*                                                                                      */
::/* DIE SOFTWARE WIRD OHNE JEDE AUSDRCKLICHE ODER IMPLIZIERTE GARANTIE                  */
::/* BEREITGESTELLT, EINSCHLIELICH DER GARANTIE ZUR BENUTZUNG FR DEN VORGESEHENEN       */
::/* ODER EINEM BESTIMMTEN ZWECK SOWIE JEGLICHER RECHTSVERLETZUNG,                        */
::/* JEDOCH NICHT DARAUF BESCHRNKT. IN KEINEM FALL SIND DIE AUTOREN ODER                 */
::/* COPYRIGHTINHABER FR JEGLICHEN SCHADEN ODER SONSTIGE ANSPRCHE HAFTBAR ZU MACHEN,    */
::/* OB INFOLGE DER ERFLLUNG EINES VERTRAGES, EINES DELIKTES ODER ANDERS                 */
::/* IM ZUSAMMENHANG MIT DER SOFTWARE ODER SONSTIGER VERWENDUNG DER SOFTWARE ENTSTANDEN.  */
::/* (MIT-Lizenz)                                                                         */
::/*                                                                                      */
::/****************************************************************************************/


::/*********************************************/
::/*Die verschiedenen Werte Abfragen und setzen*/
::/*********************************************/

@echo off & setlocal

cls
SET /P "warten=Wieviel Sekunden warten zwischen den Abfragen? "

cls
SET /P "ipadr=Welche IP-Adresse oder Domain? "

cls
SET /P "anzPing=Wieviele Pings je Abfrage "

cls
echo Was soll protokolliert werden?
SET /P "onlyError=(Nur Fehler = 1 / Alles = 0) "

SET  pingZaehler=0


::/*********************************************/
::/* Header in CSV Datei schreiben **********/
::/*********************************************/
echo Datum;Zeit;IP;SEND;RECV;LOST;MIN_MAX_AVG >>%ipadr%.csv


::/* Ping-Schlaufe luft endlos bis abgebrochen wird */
::/***************************************************/
:Again



    ::/*********************************************/
    ::/* Ausgabe als besttigung am Bildschirm *****/
    ::/*********************************************/
    set /a pingZaehler = %pingZaehler% + 1      
    cls
    echo ********************************************************
    echo ' '* 
    echo * Ping-Protokollierung von %ipadr%
    echo * ------------------------------------------------------
    echo * 
    echo * - Wartezeit zwischen den Abfragen von %warten% Sek.
    echo * - Je Abfrage werden %anzPing% pings versendet 
    echo * - Logfile ist %ipadr%.csv
    echo * 
    
IF %onlyError% == 0 (
    echo * Es werden alle Abfragen protokolliert.
    )      
IF %onlyError% == 1 (
    echo * Es werden nur fehlende Pakete protokolliert. 
    ) 
    
    echo * 
    echo * Bisher %pingZaehler% pings abgesetzt
    echo * 
    echo * Beenden mit Ctrl + C oder Schliessen des Fensters
    echo * 
    echo ********************************************************


    ::/* Pingen und ausgabe in Tempfile schreiben **/
    ::/*********************************************/
    Ping %ipadr% -n %anzPing% > %ipadr%_tmp.log
    
    
    ::/* Tempfile zeilenweise einlesen und werte errechnen und diese den Variablen zuweisen **/
    ::/***************************************************************************************/
    for /F "delims==,( skip=2 tokens=2" %%i in ('find "Pakete" %ipadr%_tmp.log') do Set "SEND=%%i"
    for /F "delims==,( skip=2 tokens=4" %%j in ('find "Pakete" %ipadr%_tmp.log') do Set "RECV=%%j"
    for /F "delims==,( skip=2 tokens=6" %%k in ('find "Pakete" %ipadr%_tmp.log') do Set "LOST=%%k"
    for /F "delims==, skip=2 tokens=2,4,6" %%i in ('find "Minimum" %ipadr%_tmp.log') do Set "MIN_MAX_AVG=%%i %%j %%k"
     
    echo .
    
    
    ::/* Die Werte in Protokolldatei schreiben je nach gewlter Protokollierart **/
    ::/***************************************************************************/    
    IF %onlyError% == 1 (
      IF NOT %LOST% == 0 (
        echo %date%; %time%; %ipadr%; %SEND%; %RECV%; %LOST%; %MIN_MAX_AVG%; >>%ipadr%.csv
        echo . %date%; %time%; %ipadr%;
        
    ))
    
    IF %onlyError% == 0 (
      echo %date%; %time%; %ipadr%; %SEND%; %RECV%; %LOST%; %MIN_MAX_AVG%; >>%ipadr%.csv
      echo %date%; %time%; %ipadr%;
    )  
    
    
    
    ::/* die gewnschte Zeit warten bevor erneuter Ping abgesetzt wird **/
    ::/******************************************************************/    
    sleep %warten%
goto :Again




goto :eof